;/********************************************************************************************************
;*
;* _irqDispatch.asm
;* Author         : A0406448
;* Date           : 14/11/2014
;*/
;/* Copyright (C) 2013-2019 Texas Instruments Incorporated - http://www.ti.com/
;*
;*
;*  Redistribution and use in source and binary forms, with or without
;*  modification, are permitted provided that the following conditions
;*  are met:
;*
;*    Redistributions of source code must retain the above copyright
;*    notice, this list of conditions and the following disclaimer.
;*
;*    Redistributions in binary form must reproduce the above copyright
;*    notice, this list of conditions and the following disclaimer in the
;*    documentation and/or other materials provided with the
;*    distribution.
;*
;*    Neither the name of Texas Instruments Incorporated nor the names of
;*    its contributors may be used to endorse or promote products derived
;*    from this software without specific prior written permission.
;*
;*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
;*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
;*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
;*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
;*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
;*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
;*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
;*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
;*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
;*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
;*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;*/
;/*---------------------------------------------------------------------------------------------------------------------
;* Revision History
;*---------------------------------------------------------------------------------------------------------------------
;* Version          Date        Author         Description
;*---------------------------------------------------------------------------------------------------------------------
;* 00.00.00       14/11/2014    A0406448        1. Initial Version
;* 00.00.01       24/09/2024    Jagadish G      1. Added license information
;***********************************************************************************************************/

;-------------------------------------------------------------------------------
; IRQ Dispatcher

        .ref phantomInterrupt
        .ref esmHighInterrupt


        .global     _irqDispatch
        .text
        .arm
        .armfunc    _irqDispatch

   .align 4
_irqDispatch:
        .asmfunc

        MOV  R8, #0xFE03
        MOVT R8, #0xFFFF
        LDRB R8, [R8] ; FIQ INTERRUPT ENTRY
        ; R8 used to get the FIQ index
        ; with address pointer to the
        ; first FIQ banked register

        ldr PC, [PC, R8, LSL#2] ; Branch to the indexed interrupt
        ; routine. The prefetch
        ; operation causes the PC to be 2
        ; words (8 bytes) ahead of the
        ; current instruction, so
        ; pointing to _INT_TABLE.

        nop ; Required due to pipeline.

        ;=================================
_INT_TABLE ; FIQ INTERRUPT DISPATCH
        ;=================================

        .word phantomInterrupt ; beginning of FIQ Dispatch
        .word esmHighInterrupt ; dispatch to interrupt routine 0
        .word phantomInterrupt ; dispatch to interrupt routine 1
        ;...
        .word phantomInterrupt ; dispatch to interrupt routine 95

        .endasmfunc

        .end
